#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//  Basic Procedural Noise TerrainMod01.fsh    by    avcourt   
//https://www.shadertoy.com/view/Ws3XRs
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*
* Author: Andrew Vaillancourt
* GitHub, Twitter: @avcourt
*
* For a detailed README see github.com/avcourt/terrain
*
*/

// CONSTANTS, try playing around with some values

// colors
const vec3 SKY_COL = vec3(0.76,0.94, 1.0);
const vec3 MTN_COL = vec3(0.4, 0.2, 0.0);
const vec3 ICE_COL = vec3(0.9, 0.9, 1.0);
const vec3 LIGHT_COL = vec3(0.95, 1.0, 0.89); // white, slightly yellow light

const float FOG_DENSITY = -0.04;
const float SKY = -1.0;                 // materialID for sky
const vec3 EPS = vec3(0.001, 0.0, 0.0); // smaller values = more detail when normalizing
const float MAX_DIST = 60.0;            // used when ray casting to limit ray length
const int RAYS = 30;                    // number of rays cast, set lower if framerate slows
const int FREQUENCY = 10;               // try lower values if framerate issues encountered

// the following are used in terrain function
const float START_HEIGHT = 0.4;
const float WEIGHT = 0.6;
const float MULT = 0.35;



// Simple 2d noise algorithm from http://shadertoy.wikia.com/wiki/Noise
// I tweaked a few values
float noise( vec2 p ) {
	vec2 f = fract(p);
	p = floor(p);
	float v = p.x+p.y*1000.0;
	vec4 r = vec4(v, v+1.0, v+1000.0, v+1001.0);
	r = fract(10000.0*sin(r*.001));
	f = f*f*(3.0-2.0*f);
	return 2.0*(mix(mix(r.x, r.y, f.x), mix(r.z, r.w, f.x), f.y))-1.0;
}


//generate terrain using above noise algorithm
float terrain( vec2 p, int freq ) {	
	float h = START_HEIGHT; // height, start at higher than zero so there's not too much snow/ice
	float w = WEIGHT; 	// weight
	float m = MULT; 	// multiplier
	for (int i = 0; i < freq; i++) {
		h += w * noise((p * m)); // adjust height based on noise algorithm
		w *= 0.5;
		m *= 2.0;
	}
	return h;
}

// this function determines how to colour, based on y.pos 
// out of the 3 basics SKY, MTN, ICE, assigns -1.0, 0.0 or 1.0
vec2 map( vec3 pos, int octaves ) {
	
	float dMin = MAX_DIST;	// nearest intersection
	float d; 		// depth
	float materialID = SKY; // set default material id to sky
	
	// rocky terrain - MTN
	float h = terrain(pos.xz, octaves);
	d = pos.y - h;
	if (d < dMin) { 
		dMin = d;
		materialID = 0.0;
	}
	// ice -set IF-statement to false to remove ice
	if (true) {
        float s = 0.05;
		d = pos.y - s;	
		if (d<dMin) { 
			dMin = d;
			materialID = 1.0;
		}
	}
	return vec2(dMin, materialID);
}

// ray casting funciton. ro = ray origin, rd = ray direction
// returns materialID
vec2 castRay( vec3 ro, vec3 rd, int freq) {
	float dist = 0.0;   // distance
	float delta = 0.2;  // step
	float material = -1.0;
	for (int i = 0; i < RAYS; i++) {
		if (dist < MAX_DIST ) {	// ignore if 'sky'
			dist += delta; 		// next step
			vec2 result = map(ro + rd*dist, freq); // get intersection
			delta = result.x; 
			material = result.y; // set material id based on y pos
		} 
		else break; //ignore 'sky'
	}
	if (dist > MAX_DIST) material = SKY; // if nothing intersects set as sky
	return vec2(dist, material);
}

// calculates normal, try changing epsilon constant
vec3 calcNormal( vec3 p, int freq) {
	return normalize( vec3(map(p + EPS.xyy, freq).x - map(p-EPS.xyy, freq).x,
			       map(p+EPS.yxy, freq).x - map(p-EPS.yxy, freq).x,
			       map(p+EPS.yyx, freq).x - map(p-EPS.yyx, freq).x) );
}



vec3 render( vec3 ro, vec3 rd ) {
	const int freq = FREQUENCY;
	
	vec3 color = SKY_COL; // base color is sky color
	vec2 res = castRay(ro, rd, freq);
	
	vec3 lightPos = normalize( vec3(1.0, 0.9, 0.0) ); // light position
	
	vec3 pos = ro + rd*res.x; // world position
	
	// material  = sky
	if (res.y < -0.5) {
		color = SKY_COL;
		return color;
	}
	// now we can calculate normals for moutnains and ice
    vec3 normal = calcNormal(pos, 10); 

	// material = MTN 
	if (res.y > -0.5 && res.y < 0.5 ) {	
        color = MTN_COL;	
		// add light
		float ambient = clamp( 0.5 + 0.5 * normal.y, 0.0, 1.0); // ambient
		float diffuse = clamp( dot( normal, lightPos ), 0.0, 5.0); // diffuse		
		color += (0.4 * ambient) * LIGHT_COL;
		color *= (1.9 * diffuse) * LIGHT_COL;	
	}
	// material = ICE
	if (res.y > 0.5) {
        color = ICE_COL;
			
		// add light
		float ambient = clamp( 0.5 + 0.5 * normal.y, 0.0, 1.0);     // ambient
		float diffuse = clamp( dot( normal, lightPos ), 0.0, 2.0);  // diffuse
	
		color += (0.3 * ambient) * LIGHT_COL;
		color *= (2.1 * diffuse) * LIGHT_COL;
	}
	
	// fog from http://in2gpu.com/2014/07/22/create-fog-shader/
	float fog = exp(FOG_DENSITY * res.x); 
	color = mix(vec3(0.3,0.3,0.35), color, fog); 
		
	return color;
}
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 


	vec2 pos = 2.0 * ( fragCoord.xy / iResolution.xy ) - 1.0; // bound screen coords to [0, 1]
	pos.x *= iResolution.x / iResolution.y; // set aspect ratio

	// camera
	float x = 0.0 + (2.5*iTime);
	float y = 3.0;
    float z = 1.0;
	vec3 camPos = vec3(x, y, z); // set camera position
	
	const vec3 up = vec3(0.0, 1.0, 0.0); // up vector
	vec3 camLook = vec3(camPos.x + 1.0, y*0.8, 0.0); // lookAt vector
	
	
	vec3 w = normalize( camLook - camPos );
	vec3 u = normalize( cross(w, up) );
	vec3 v = normalize( cross(u, w) );
	
	vec3 rd = normalize( pos.x*u + pos.y*v + 2.0*w );
	
	// render
	vec3 color = render(camPos, rd);
	
	fragColor = vec4( color, 1.0 );
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

